(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     98098,       2441]
NotebookOptionsPosition[     93873,       2303]
NotebookOutlinePosition[     94439,       2322]
CellTagsIndexPosition[     94396,       2319]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Class 05 Vector-Valued Function Applications\
\>", "Title",
 CellChangeTimes->{{3.544798575870993*^9, 3.544798584388549*^9}, {
  3.576837003801124*^9, 3.5768370046704807`*^9}}],

Cell[CellGroupData[{

Cell["05 Vector-Valued Function Applications", "Section",
 CellChangeTimes->{{3.544798615502203*^9, 3.544798627912608*^9}, 
   3.576837010733515*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 "Consider ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["r",
       FontWeight->"Bold"], "(", "t", ")"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["e", "t"], "sin", " ", "t"}], ",", 
       RowBox[{
        SuperscriptBox["e", "t"], "cos", " ", "t"}], ",", " ", 
       SuperscriptBox["e", "t"]}], "\[RightAngleBracket]"}]}], ",", 
    RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", 
     RowBox[{"2", "\[Pi]"}]}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"b", "(", 
      StyleBox["t",
       FontWeight->"Plain"], ")"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{"t", " ", 
        RowBox[{"sin", "(", 
         RowBox[{"ln", " ", "t"}], ")"}]}], ",", 
       RowBox[{"t", " ", 
        RowBox[{"cos", "(", 
         RowBox[{"ln", " ", "t"}], ")"}]}], ",", "t"}], 
      "\[RightAngleBracket]"}]}], ",", 
    RowBox[{"1", "\[LessEqual]", "t", "\[LessEqual]", 
     SuperscriptBox["e", 
      RowBox[{"2", "\[Pi]"}]]}]}], TraditionalForm]]],
 ".  How are these two vector-valued functions the same?  How are they \
different?  What are their lengths?"
}], "Subsubsection",
 CellChangeTimes->{{3.544798658907484*^9, 3.544798661461194*^9}, {
   3.544798754332018*^9, 3.5447989218883576`*^9}, {3.5447989541400585`*^9, 
   3.544799060659006*^9}, {3.5448012298042216`*^9, 3.544801243743148*^9}, {
   3.5448019260102797`*^9, 3.544801936666502*^9}, {3.5448250869858484`*^9, 
   3.5448250882049184`*^9}, 3.544825120804783*^9}],

Cell[TextData[{
 "Their parametric plots are the same; however, their dynamics are different. \
 Hence, their arc lengths must be the same but their velocities differ.  In \
fact, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
 " speeds up while ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["s",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
 " maintains a constant speed.  "
}], "Text",
 CellChangeTimes->{{3.5448010045256853`*^9, 3.5448010251931343`*^9}, {
   3.5448012800206976`*^9, 3.544801303231429*^9}, {3.5448016385893407`*^9, 
   3.5448017733945312`*^9}, 3.5448034563146954`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"r", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "t"], 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "t"], 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     SuperscriptBox["\[ExponentialE]", "t"]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotr", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"r", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"Log", "[", "t", "]"}], "]"}]}], ",", 
     RowBox[{"t", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"Log", "[", "t", "]"}], "]"}]}], ",", "t"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotb", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"b", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", "\[Pi]"}]]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"plotr", ",", "plotb", ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotr", ",", "plotb"}], "]"}]}], 
  "}"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.544799312780158*^9, {3.544799427780089*^9, 3.544799427936144*^9}, {
   3.5447995091179557`*^9, 3.544799513659156*^9}, {3.544799799460224*^9, 
   3.5447997996163025`*^9}, 3.5447998394659624`*^9, {3.544799962872347*^9, 
   3.544800129515912*^9}, {3.544800164855462*^9, 3.5448001693196077`*^9}, {
   3.544801123970521*^9, 3.5448011299185886`*^9}, {3.544825143886103*^9, 
   3.5448251758539314`*^9}, 3.576847911503943*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Line3DBox[CompressedData["
1:eJwt13k01N//B/CxRPadxNj3JVvJlvsahJE1CglZxr5XSBhCtkoKFUkpIS1I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       "]]}},
    Axes->True,
    Method->{},
    PlotRange->{{-172.6408433401136, 
     7.460483455311176}, {-35.888499971236236`, 145.7565814171939}, {0., 
     366.19980974166975`}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   Graphics3DBox[{{}, {}, 
     {RGBColor[1, 0, 0], Line3DBox[CompressedData["
1:eJwt13VQVc/7B3BAWkBASrpLFKSl7nPpTkWkJO6luSAl7UVBQUJCLKQVBWkp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       "]]}},
    Axes->True,
    Method->{},
    PlotRange->{{-172.64087167044886`, 
     7.460382565289573}, {-35.88851127474776, 535.4916445963634}, {0., 
     535.4916445963635}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   Graphics3DBox[{{{}, {}, 
      {Hue[0.67, 0.6, 0.6], Line3DBox[CompressedData["
1:eJwt13k01N//B/CxRPadxNj3JVvJlvsahJE1CglZxr5XSBhCtkoKFUkpIS1I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        "]]}}, {{}, {}, 
      {RGBColor[1, 0, 0], Line3DBox[CompressedData["
1:eJwt13VQVc/7B3BAWkBASrpLFKSl7nPpTkWkJO6luSAl7UVBQUJCLKQVBWkp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        "]]}}},
    Axes->True,
    Method->{},
    PlotRange->{{-172.6408433401136, 
     7.460483455311176}, {-35.888499971236236`, 145.7565814171939}, {0., 
     366.19980974166975`}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5447995141117153`*^9, 3.544799800427908*^9, 3.544799965900435*^9, 
   3.544800130280748*^9, 3.5448001714112*^9, 3.5448251780010543`*^9, 
   3.576598400986607*^9, 3.576836999663744*^9, 3.57683715070793*^9, {
   3.5768373206205378`*^9, 3.576837342004225*^9}, 3.576837508311838*^9, 
   3.576837690723598*^9, 3.5768453455805607`*^9, 3.576846691981751*^9, 
   3.5768479150061903`*^9, 3.5769218415821753`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "t_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "t"], 
        RowBox[{"Sin", "[", "t", "]"}]}], ",", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "t"], 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       SuperscriptBox["\[ExponentialE]", "t"]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"r", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"PointSize", "[", ".02", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"r", "[", "t", "]"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r", "[", "t", "]"}], ",", 
            RowBox[{
             RowBox[{"r", "[", "t", "]"}], "+", 
             RowBox[{
              RowBox[{"r", "'"}], "[", "t", "]"}]}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2 Pi}}, Typeset`size$$ = {
    335., {266., 274.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$357$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$357$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`r[
          Pattern[$CellContext`t, 
           Blank[]]] := {
         E^$CellContext`t Sin[$CellContext`t], E^$CellContext`t 
          Cos[$CellContext`t], E^$CellContext`t}; Show[
         ParametricPlot3D[
          $CellContext`r[$CellContext`t$$], {$CellContext`t$$, 0, 2 Pi}], 
         Graphics3D[{Blue, 
           PointSize[0.02], 
           Point[
            $CellContext`r[$CellContext`t$$]], 
           Arrow[{
             $CellContext`r[$CellContext`t$$], \
$CellContext`r[$CellContext`t$$] + 
             Derivative[1][$CellContext`r][$CellContext`t$$]}]}]]), 
      "Specifications" :> {{$CellContext`t$$, 0, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{392., {321., 328.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.576837082141075*^9, 3.576837150926609*^9, 
  3.5768373502937937`*^9, 3.5768375351704893`*^9, 3.576837694059186*^9, 
  3.576845351349967*^9, 3.57684791932732*^9, 3.5769218419409933`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", "[", "t_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"Log", "[", "t", "]"}], "]"}]}], ",", 
       RowBox[{"t", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"Log", "[", "t", "]"}], "]"}]}], ",", "t"}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"b", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", "\[Pi]"}]]}], "}"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", ".02", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"b", "[", "t", "]"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"b", "[", "t", "]"}], ",", 
            RowBox[{
             RowBox[{"b", "[", "t", "]"}], "+", 
             RowBox[{
              RowBox[{"b", "'"}], "[", "t", "]"}]}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", "\[Pi]"}]]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.54480057720229*^9, 3.544800596340925*^9}, {
   3.544800640390524*^9, 3.54480064060905*^9}, {3.544800836948057*^9, 
   3.5448008570212913`*^9}, 3.5448121419347253`*^9, {3.544825208377792*^9, 
   3.5448252254767694`*^9}, {3.544825272812477*^9, 3.544825275028604*^9}, {
   3.576598543528225*^9, 3.57659858404593*^9}, 3.5765986170661583`*^9, {
   3.576598672474578*^9, 3.576598685705652*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 1, E^(2 Pi)}}, Typeset`size$$ = {
    333., {266., 274.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$413$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$413$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`b[
          Pattern[$CellContext`t, 
           Blank[]]] := {$CellContext`t Sin[
            Log[$CellContext`t]], $CellContext`t Cos[
            Log[$CellContext`t]], $CellContext`t}; Show[
         ParametricPlot3D[
          $CellContext`b[$CellContext`t$$], {$CellContext`t$$, 0, E^(2 Pi)}, 
          PlotStyle -> Red], 
         Graphics3D[{Red, 
           PointSize[0.02], 
           Point[
            $CellContext`b[$CellContext`t$$]], 
           Arrow[{
             $CellContext`b[$CellContext`t$$], \
$CellContext`b[$CellContext`t$$] + 
             Derivative[1][$CellContext`b][$CellContext`t$$]}]}]]), 
      "Specifications" :> {{$CellContext`t$$, 1, E^(2 Pi)}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{390., {321., 328.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.576598459439891*^9, {3.576598546882156*^9, 3.576598552579702*^9}, 
   3.576598618803706*^9, 3.5765986883832483`*^9, 3.5768370602164497`*^9, 
   3.576837151016659*^9, 3.576837355245998*^9, 3.576837539470634*^9, 
   3.57683769819552*^9, 3.576845358149136*^9, 3.576847923374134*^9, 
   3.5769218423466144`*^9}]
}, Open  ]],

Cell["\<\
Derive the arc length formula and then apply to this problem.\
\>", "Text",
 CellChangeTimes->{{3.5448010045256853`*^9, 3.5448010251931343`*^9}, {
   3.5448012800206976`*^9, 3.544801303231429*^9}, {3.5448016385893407`*^9, 
   3.5448017733945312`*^9}, 3.5448019893719177`*^9, {3.5448020215425053`*^9, 
   3.5448020479505725`*^9}, {3.5448262569677677`*^9, 3.544826263403136*^9}}],

Cell["\<\
If r [ t ] is position, then r \[CloseCurlyQuote] [ t ] is velocity and | r \
\[OpenCurlyQuote] [ t ] | is speed.\
\>", "Text",
 CellChangeTimes->{{3.5768456809495573`*^9, 3.576845735918776*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "'"}], "[", "t", "]"}]], "Input",
 CellChangeTimes->{{3.5768456429078817`*^9, 3.5768456454212*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "t"], " ", 
     RowBox[{"Cos", "[", "t", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "t"], " ", 
     RowBox[{"Sin", "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "t"], " ", 
     RowBox[{"Cos", "[", "t", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "t"], " ", 
     RowBox[{"Sin", "[", "t", "]"}]}]}], ",", 
   SuperscriptBox["\[ExponentialE]", "t"]}], "}"}]], "Output",
 CellChangeTimes->{3.5768456472158203`*^9, 3.576847927888987*^9, 
  3.576921842862441*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"r", "'"}], "[", "t", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.576845743865705*^9, 3.5768457535436707`*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", 
     RowBox[{"Re", "[", "t", "]"}]}]], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "t"], " ", 
       RowBox[{"Cos", "[", "t", "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "t"], " ", 
       RowBox[{"Sin", "[", "t", "]"}]}]}], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "t"], " ", 
       RowBox[{"Cos", "[", "t", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "t"], " ", 
       RowBox[{"Sin", "[", "t", "]"}]}]}], "]"}], "2"]}]]], "Output",
 CellChangeTimes->{3.576845754431013*^9, 3.576847930993272*^9, 
  3.576921843127654*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"r", "'"}], "[", "t", "]"}], "]"}], ",", 
   RowBox[{"t", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576845768982361*^9, 3.5768457818767633`*^9}}],

Cell[BoxData[
 RowBox[{
  SqrtBox["3"], " ", 
  SuperscriptBox["\[ExponentialE]", "t"]}]], "Output",
 CellChangeTimes->{3.576845782393175*^9, 3.576847939520471*^9, 
  3.5769218435020733`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"integrandr", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"r", "'"}], "[", "t", "]"}], "]"}], ",", 
    RowBox[{"t", "\[Element]", "Reals"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"integrandr", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.5448002034728813`*^9, 3.5448002356604342`*^9}, {
  3.5448258736628437`*^9, 3.5448258789301453`*^9}}],

Cell[BoxData[
 RowBox[{
  SqrtBox["3"], " ", 
  SuperscriptBox["\[ExponentialE]", "t"]}]], "Output",
 CellChangeTimes->{3.5448002370027995`*^9, 3.5448258802792225`*^9, 
  3.576598712460236*^9, 3.576837151248251*^9, 3.576837380481797*^9, 
  3.57683772543288*^9, 3.5768479429194603`*^9, 3.5769218439700975`*^9}],

Cell[BoxData[
 RowBox[{
  SqrtBox["3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "\[Pi]"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.5448002370027995`*^9, 3.5448258802792225`*^9, 
  3.576598712460236*^9, 3.576837151248251*^9, 3.576837380481797*^9, 
  3.57683772543288*^9, 3.5768479429194603`*^9, 3.5769218445317264`*^9}],

Cell[BoxData["925.7667035904947`"], "Output",
 CellChangeTimes->{3.5448002370027995`*^9, 3.5448258802792225`*^9, 
  3.576598712460236*^9, 3.576837151248251*^9, 3.576837380481797*^9, 
  3.57683772543288*^9, 3.5768479429194603`*^9, 3.5769218445317264`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"integrands", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"b", "'"}], "[", "t", "]"}], "]"}], ",", 
    RowBox[{
     RowBox[{"t", "\[Element]", "Reals"}], " ", "&&", " ", 
     RowBox[{"t", ">", "0"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"integrands", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", "\[Pi]"}]]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544800274137545*^9, 3.54480032027875*^9}, {
  3.544800368496952*^9, 3.54480036868426*^9}, {3.5448262847213554`*^9, 
  3.544826284827361*^9}}],

Cell[BoxData[
 SqrtBox["3"]], "Output",
 CellChangeTimes->{{3.5448002917132792`*^9, 3.544800321558688*^9}, 
   3.544800370619776*^9, 3.5448262907406993`*^9, 3.576598716206623*^9, 
   3.5768371519869947`*^9, 3.5768373842191973`*^9, 3.576837728618788*^9, 
   3.576847946156592*^9, 3.5769218446097307`*^9}],

Cell[BoxData[
 RowBox[{
  SqrtBox["3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "\[Pi]"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.5448002917132792`*^9, 3.544800321558688*^9}, 
   3.544800370619776*^9, 3.5448262907406993`*^9, 3.576598716206623*^9, 
   3.5768371519869947`*^9, 3.5768373842191973`*^9, 3.576837728618788*^9, 
   3.576847946156592*^9, 3.576921844625331*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["What is special about an arc length parametrization?", "Subsubsection",
 CellChangeTimes->{{3.544803343365534*^9, 3.5448033541768565`*^9}}],

Cell[TextData[{
 "The length of the tangent vector is always one (constant speed of one), \
i.e., ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     RowBox[{
      RowBox[{"r", "'"}], 
      RowBox[{"(", "t", ")"}]}], "||"}], "=", "1"}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.5448034043089013`*^9, 3.544803428558597*^9}, {
  3.5448115864996605`*^9, 3.5448115926208844`*^9}, {3.544827536298941*^9, 
  3.544827589652993*^9}}],

Cell[TextData[{
 "For the previous example, find an arc length parametrization first from ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]],
  FontWeight->"Bold"],
 " (constant rescaling of time) and then from ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    FontWeight->"Bold"], TraditionalForm]]],
 " (variable rescaling of time)."
}], "Text",
 CellChangeTimes->{{3.544802442706366*^9, 3.5448024743366766`*^9}, {
  3.5448025546611958`*^9, 3.5448025572970552`*^9}, {3.544802611823468*^9, 
  3.544802633331455*^9}, {3.544802721181967*^9, 3.5448027786470795`*^9}, {
  3.5448034383154984`*^9, 3.544803443101412*^9}, {3.5448263141700397`*^9, 
  3.5448263171242085`*^9}}],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["c",
       FontWeight->"Bold"], "(", "t", ")"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{
        FractionBox["t", 
         SqrtBox["3"]], " ", 
        RowBox[{"sin", "(", 
         RowBox[{"ln", " ", 
          FractionBox["t", 
           SqrtBox["3"]]}], ")"}]}], ",", 
       RowBox[{
        FractionBox["t", 
         SqrtBox["3"]], " ", 
        RowBox[{"cos", "(", 
         RowBox[{"ln", " ", 
          FractionBox["t", 
           SqrtBox["3"]]}], ")"}]}], ",", 
       FractionBox["t", 
        SqrtBox["3"]]}], "\[RightAngleBracket]"}]}], ",", 
    RowBox[{
     SqrtBox["3"], "\[LessEqual]", "t", "\[LessEqual]", 
     RowBox[{
      SqrtBox["3"], 
      SuperscriptBox["e", 
       RowBox[{"2", "\[Pi]"}]]}]}]}], TraditionalForm]]],
 " "
}], "Text",
 CellChangeTimes->{{3.5448037714116836`*^9, 3.544803883289417*^9}, {
   3.54480679304622*^9, 3.5448068001323447`*^9}, 3.544806913446329*^9, {
   3.5448263433537087`*^9, 3.5448263448337936`*^9}, {3.5448264032461343`*^9, 
   3.544826403622156*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "[", "t_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["t", 
      SqrtBox["3"]], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", " ", 
       FractionBox["t", 
        SqrtBox["3"]], "]"}], "]"}]}], ",", 
    RowBox[{
     FractionBox["t", 
      SqrtBox["3"]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"Log", "[", " ", 
       FractionBox["t", 
        SqrtBox["3"]], "]"}], "]"}]}], ",", 
    FractionBox["t", 
     SqrtBox["3"]]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"c", "'"}], "[", "t", "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"t", "\[Element]", "Reals"}], " ", "&&", 
    RowBox[{"t", ">", "0"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544827867165866*^9, 3.5448279816334133`*^9}, {
  3.544828013762251*^9, 3.5448280272610226`*^9}, {3.544828057689763*^9, 
  3.544828065291198*^9}, {3.5448287979871054`*^9, 3.544828887073201*^9}, {
  3.544829015283534*^9, 3.5448290205148335`*^9}, {3.5448291166763334`*^9, 
  3.544829132658248*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.5448280694424353`*^9, 3.54482883057997*^9, {3.5448288608297*^9, 
   3.544828888243268*^9}, 3.5448290383688545`*^9, 3.5448291347143655`*^9, 
   3.57659872441276*^9, 3.576837152184986*^9, 3.576837282580982*^9, 
   3.576837390419773*^9, 3.5768375549194527`*^9, 3.5768377348736677`*^9, 
   3.576846781612007*^9, 3.5768469267877073`*^9, 3.576847953845395*^9, 
   3.5769218453117666`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
What is the difference between the tangent vector and the unit tangent vector?\
\>", "Subsubsection",
 CellChangeTimes->{{3.544803508342498*^9, 3.5448035334085207`*^9}, {
  3.544803595809471*^9, 3.544803600267253*^9}}],

Cell[TextData[{
 "Given a vector-valued function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
 ", the tangent vector is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "'"}], 
    RowBox[{"(", "t", ")"}]}], TraditionalForm]]],
 " and the unit tangent vector is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["T",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["r",
        FontWeight->"Bold"], "'"}], 
      RowBox[{
       RowBox[{"(", "t", ")"}], "/"}]}], "||", 
     RowBox[{
      RowBox[{
       StyleBox["r",
        FontWeight->"Bold"], "'"}], 
      RowBox[{"(", "t", ")"}]}], "||"}]}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.5448035699031124`*^9, 3.544803705519337*^9}}],

Cell["\<\
The tangent vector depends on the parametrization, but the unit tangent \
vector is independent of parametrization.\
\>", "Text",
 CellChangeTimes->{{3.544828613405548*^9, 3.5448286705578175`*^9}}],

Cell[TextData[{
 "The unit normal vector is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["N",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      StyleBox["T",
       FontWeight->"Bold"], "'"}], 
     RowBox[{
      RowBox[{"(", "t", ")"}], "/", 
      RowBox[{"\[LeftDoubleBracketingBar]", 
       RowBox[{
        RowBox[{
         StyleBox["T",
          FontWeight->"Bold"], "'"}], 
        RowBox[{"(", "t", ")"}]}], "\[RightDoubleBracketingBar]"}]}]}]}], 
   TraditionalForm]]],
 ".  Why is this called the normal vector?"
}], "Text",
 CellChangeTimes->{{3.5448282204170704`*^9, 3.544828321062827*^9}, {
  3.544828715982415*^9, 3.5448287167584596`*^9}}],

Cell[TextData[{
 "Show ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     FontWeight->"Bold"], 
    StyleBox["\[UpTee]",
     FontWeight->"Bold"], 
    RowBox[{
     StyleBox["r",
      FontWeight->"Plain"], 
     StyleBox["'",
      FontWeight->"Bold"]}]}], TraditionalForm]]],
 " if and only if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftDoubleBracketingBar]", 
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "'"}], "\[RightDoubleBracketingBar]"}], 
   TraditionalForm]]],
 " is a constant.  (Consider ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[DifferentialD]", 
     RowBox[{"\[DifferentialD]", "t"}]], 
    SuperscriptBox[
     RowBox[{"\[LeftDoubleBracketingBar]", 
      RowBox[{
       RowBox[{
        StyleBox["r",
         FontWeight->"Bold"], "'"}], 
       RowBox[{"(", "t", ")"}]}], "\[RightDoubleBracketingBar]"}], "2"]}], 
   TraditionalForm]]],
 ".  Also explain geometrically.)"
}], "Text",
 CellChangeTimes->{{3.5448117335850716`*^9, 3.5448118427178936`*^9}, {
  3.54482721353048*^9, 3.544827276111059*^9}, {3.544827347652151*^9, 
  3.544827356056632*^9}}],

Cell[TextData[{
 "Hence, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["N",
      FontWeight->"Bold"], "(", "t", ")"}], "\[UpTee]", 
    RowBox[{
     StyleBox["T",
      FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]],
 ", and both are independent of parametrization."
}], "Text",
 CellChangeTimes->{{3.544828357612918*^9, 3.5448283858405323`*^9}, {
  3.544828734909498*^9, 3.5448287493803253`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["What is curvature?", "Subsubsection",
 CellChangeTimes->{{3.5448070683807955`*^9, 3.5448070725810547`*^9}}],

Cell["\<\
Intuitively, a measure of how fast a curve is bending.  Sounds a bit like a \
second derivative.  Should be independent of the parametrization of the \
curve.  Lines (zero curvature) and circles (constant curvature on a fixed \
circle and increasing curvature as the radius decreases) should serve as \
standards.\
\>", "Text",
 CellChangeTimes->{{3.544827629327262*^9, 3.5448276966841145`*^9}, {
  3.544827732600169*^9, 3.5448278044272776`*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Kappa]", "(", "s", ")"}], "=", 
    RowBox[{"\[LeftDoubleBracketingBar]", 
     FractionBox[
      RowBox[{"\[DifferentialD]", 
       StyleBox["T",
        FontWeight->"Bold"]}], 
      RowBox[{"\[DifferentialD]", "s"}]], "\[RightDoubleBracketingBar]"}]}], 
   TraditionalForm]]],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
 " is an arc length parametrization and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["T",
     FontWeight->"Bold"], 
    StyleBox["(",
     FontWeight->"Plain"], 
    StyleBox["t",
     FontWeight->"Plain"], 
    StyleBox[")",
     FontWeight->"Plain"]}], TraditionalForm]]],
 " is the unit tangent vector."
}], "Text",
 CellChangeTimes->{{3.5448070851848345`*^9, 3.5448070935133324`*^9}, {
  3.5448071477886105`*^9, 3.5448071582157373`*^9}, {3.544807297595539*^9, 
  3.544807309339061*^9}, {3.5448079600362115`*^9, 3.5448079869672885`*^9}, {
  3.5448081201852417`*^9, 3.5448081237443094`*^9}, {3.544808500609335*^9, 
  3.544808515605832*^9}, {3.544808801019431*^9, 3.544808849281905*^9}}],

Cell["Motivation for using a constant speed parametrization:", "Text",
 CellChangeTimes->{{3.5448115220627756`*^9, 3.544811572999961*^9}, {
  3.5448265130254135`*^9, 3.54482652082786*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"r1", "[", "t_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["t", "2"], ",", 
       SuperscriptBox["t", "2"]}], "}"}]}], ";", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"r1", "[", "1", "]"}], ",", 
           RowBox[{"r1", "[", "3", "]"}]}], "}"}], "]"}], ",", "Red", ",", 
        RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"r1", "[", "t", "]"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"r1", "[", "t", "]"}], ",", 
           RowBox[{
            RowBox[{"r1", "[", "t", "]"}], "+", 
            RowBox[{
             RowBox[{"r1", "'"}], "[", "t", "]"}]}]}], "}"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "15"}], "}"}]}], "}"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544809391353839*^9, 3.544809624489056*^9}, {
   3.544809969941442*^9, 3.5448099829577436`*^9}, {3.544810362013812*^9, 
   3.544810367757961*^9}, {3.5448104300714207`*^9, 3.544810430470501*^9}, 
   3.544810515098423*^9, {3.544810553215045*^9, 3.5448105568007617`*^9}, {
   3.5448106157555504`*^9, 3.544810641004599*^9}, {3.5448106753594685`*^9, 
   3.5448106785150995`*^9}, 3.5448115128129263`*^9, {3.576837404501651*^9, 
   3.5768374275380363`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 1, 3}}, Typeset`size$$ = {450., {223., 230.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$588$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$588$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`r1[
          Pattern[$CellContext`t, 
           Blank[]]] := {$CellContext`t^2, $CellContext`t^2}; Graphics[{
          Line[{
            $CellContext`r1[1], 
            $CellContext`r1[3]}], Red, 
          PointSize[0.02], 
          Point[
           $CellContext`r1[$CellContext`t$$]], 
          Arrow[{
            $CellContext`r1[$CellContext`t$$], \
$CellContext`r1[$CellContext`t$$] + 
            Derivative[1][$CellContext`r1][$CellContext`t$$]}]}, Axes -> True,
          PlotRange -> {{0, 15}, {0, 15}}]), 
      "Specifications" :> {{$CellContext`t$$, 1, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{507., {277., 284.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.576921845654984*^9}]
}, Open  ]],

Cell["\<\
Motivation for using the unit tangent vector and a fixed speed (chosen to be \
1 by convention):\
\>", "Text",
 CellChangeTimes->{{3.544811602509862*^9, 3.544811617024764*^9}, {
  3.5448269170685234`*^9, 3.5448269295072346`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"r2", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", "t"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "t"}], "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", "Red", ",", 
       RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"r2", "[", "t", "]"}], "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r2", "[", "t", "]"}], ",", 
          RowBox[{
           RowBox[{"r2", "[", "t", "]"}], "+", 
           RowBox[{
            RowBox[{"r2", "'"}], "[", "t", "]"}]}]}], "}"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544809391353839*^9, 3.544809624489056*^9}, {
   3.5448097370388002`*^9, 3.544809745068997*^9}, {3.544809787681735*^9, 
   3.5448098345540476`*^9}, {3.5448098659929037`*^9, 
   3.5448099052869773`*^9}, {3.544809995652013*^9, 3.544810004878936*^9}, {
   3.544810062401687*^9, 3.5448100672741747`*^9}, {3.5448101329817443`*^9, 
   3.5448101385503016`*^9}, 3.544810217458907*^9, {3.5448116218277245`*^9, 
   3.5448116758935356`*^9}, {3.5448265969852157`*^9, 3.544826598971329*^9}, {
   3.544826945792166*^9, 3.544826964326226*^9}, {3.576837433671699*^9, 
   3.576837456310817*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2 Pi}}, Typeset`size$$ = {
    450., {224., 231.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$612$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$612$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Circle[{0, 0}, 1], Red, 
         PointSize[0.02], 
         Point[
          $CellContext`r2[$CellContext`t$$]], 
         Arrow[{
           $CellContext`r2[$CellContext`t$$], \
$CellContext`r2[$CellContext`t$$] + 
           Derivative[1][$CellContext`r2][$CellContext`t$$]}]}, Axes -> True, 
        PlotRange -> {{-2, 2}, {-2, 2}}], 
      "Specifications" :> {{$CellContext`t$$, 0, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{507., {278., 285.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.5769218460918064`*^9}]
}, Open  ]],

Cell[TextData[{
 "Show ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Kappa]", "(", "s", ")"}], "=", "0"}], TraditionalForm]]],
 " for a straight line and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Kappa]", "(", "s", ")"}], "=", 
    RowBox[{"1", "/", "R"}]}], TraditionalForm]]],
 " for a circle of radius R.  Also compute the unit normal and draw."
}], "Text",
 CellChangeTimes->{{3.5448088889818115`*^9, 3.544808938493661*^9}, {
  3.5448315375157976`*^9, 3.544831551297586*^9}}],

Cell["Compute curvature for our example.", "Text",
 CellChangeTimes->{{3.544829102603529*^9, 3.5448291090989003`*^9}, {
  3.544829161250883*^9, 3.544829163483011*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", "t_", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["t", 
      SqrtBox["3"]], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", " ", 
       FractionBox["t", 
        SqrtBox["3"]], "]"}], "]"}]}], ",", 
    RowBox[{
     FractionBox["t", 
      SqrtBox["3"]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"Log", "[", " ", 
       FractionBox["t", 
        SqrtBox["3"]], "]"}], "]"}]}], ",", 
    FractionBox["t", 
     SqrtBox["3"]]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.576846979739093*^9, 3.576847026285108*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"t", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", 
       FractionBox["t", 
        SqrtBox["3"]], "]"}], "]"}]}], 
    SqrtBox["3"]], ",", 
   FractionBox[
    RowBox[{"t", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"Log", "[", 
       FractionBox["t", 
        SqrtBox["3"]], "]"}], "]"}]}], 
    SqrtBox["3"]], ",", 
   FractionBox["t", 
    SqrtBox["3"]]}], "}"}]], "Output",
 CellChangeTimes->{3.576847026948208*^9, 3.576847964642817*^9, 
  3.576921847464677*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"uT", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{"c", "'"}], "[", "s", "]"}]}]], "Input",
 CellChangeTimes->{{3.576847038551776*^9, 3.576847152731224*^9}, {
   3.576847374562088*^9, 3.57684738251014*^9}, 3.5768474238546553`*^9, 
   3.576847485446261*^9, {3.5768479690478983`*^9, 3.5768479739979677`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uT", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.576848113979982*^9, 3.5768481189017982`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
     SqrtBox["3"]], "-", 
    FractionBox[
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
     SqrtBox["3"]]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
     SqrtBox["3"]], "+", 
    FractionBox[
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
     SqrtBox["3"]]}], ",", 
   FractionBox["1", 
    SqrtBox["3"]]}], "}"}]], "Output",
 CellChangeTimes->{3.576848119542961*^9, 3.5769218479171*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Kappa]", "[", "s_", "]"}], ":=", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"uT", "'"}], "[", "s", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.576847184396617*^9, 3.576847209232958*^9}, 
   3.576847479638489*^9, {3.5768475315024443`*^9, 3.5768475349248953`*^9}, {
   3.576847989958043*^9, 3.576848009845127*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Kappa]", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.5768475184638042`*^9, 3.5768475231024313`*^9}, {
  3.576848083333473*^9, 3.576848084267941*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
       SqrtBox["3"]], "-", 
      FractionBox[
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
       SqrtBox["3"]]}], ")"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
       SqrtBox["3"]], "+", 
      FractionBox[
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
       SqrtBox["3"]]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.576847524409808*^9, 3.576847545501347*^9}, {
   3.576848079717641*^9, 3.576848084809228*^9}, 3.5769218483071203`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"\[Kappa]", "[", "s", "]"}], ",", 
   RowBox[{
    RowBox[{"s", "\[Element]", "Reals"}], " ", "&&", 
    RowBox[{"s", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576847551375641*^9, 3.576847569935117*^9}, {
  3.5768480165290623`*^9, 3.576848016993073*^9}}],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "3"]], "s"]], "Output",
 CellChangeTimes->{3.576847570966297*^9, 3.576848018533733*^9, 
  3.5769218486503377`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"uN", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"uT", "'"}], "[", "s", "]"}], "/", 
   RowBox[{"\[Kappa]", "[", "s", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.576847577325513*^9, 3.576847610692493*^9}, {
  3.5768480220302563`*^9, 3.5768480433738117`*^9}, {3.57684815420757*^9, 
  3.576848156506928*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uN", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.576847613629858*^9, 3.576847615554223*^9}, {
  3.5768480598203497`*^9, 3.5768480916201143`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     FractionBox[
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
      SqrtBox["3"]], "+", 
     FractionBox[
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
      SqrtBox["3"]]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
          SqrtBox["3"]], "-", 
         FractionBox[
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
          SqrtBox["3"]]}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
          SqrtBox["3"]], "+", 
         FractionBox[
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
          SqrtBox["3"]]}], ")"}], "2"]}]]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
       SqrtBox["3"]]}], "+", 
     FractionBox[
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
      SqrtBox["3"]]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
          SqrtBox["3"]], "-", 
         FractionBox[
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
          SqrtBox["3"]]}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
          SqrtBox["3"]], "+", 
         FractionBox[
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{"Log", "[", "3", "]"}], "2"], "]"}], 
          SqrtBox["3"]]}], ")"}], "2"]}]]], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.576847616375095*^9, {3.576848060747354*^9, 3.576848099385652*^9}, 
   3.576848159871122*^9, 3.576921849071559*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"uN", "[", "s", "]"}], ",", 
   RowBox[{
    RowBox[{"s", "\[Element]", "Reals"}], " ", "&&", 
    RowBox[{"s", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.576847623252709*^9, 3.5768476366442537`*^9}, {
  3.5768480501653013`*^9, 3.576848050624737*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"Log", "[", 
       FractionBox["s", 
        SqrtBox["3"]], "]"}], "]"}], "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"Log", "[", 
       FractionBox["s", 
        SqrtBox["3"]], "]"}], "]"}]}], 
    SqrtBox["2"]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"Log", "[", 
        FractionBox["s", 
         SqrtBox["3"]], "]"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"Log", "[", 
        FractionBox["s", 
         SqrtBox["3"]], "]"}], "]"}]}], 
     SqrtBox["2"]]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.576847637143195*^9, 3.576848051512455*^9, 
  3.5768481639185543`*^9, 3.576921849508382*^9}]
}, Open  ]],

Cell[TextData[{
 "Compute the osculating circle at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{
     SqrtBox["3"], 
     SuperscriptBox["\[ExponentialE]", "\[Pi]"]}]}], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.54483189841544*^9, 3.5448319558727264`*^9}, {
  3.5765987757111177`*^9, 3.576598776710766*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"radius", "=", 
  RowBox[{"1", "/", 
   RowBox[{"\[Kappa]", "[", 
    RowBox[{
     SqrtBox["3"], 
     SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"center", "=", 
  RowBox[{
   RowBox[{"c", "[", 
    RowBox[{
     SqrtBox["3"], 
     SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "]"}], "+", 
   RowBox[{"radius", " ", 
    RowBox[{"uN", "[", 
     RowBox[{
      SqrtBox["3"], 
      SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "]"}]}]}]}], "\n", 
 FractionBox[
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], 
  SqrtBox["2"]], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "2"]}], ",", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", "\[Pi]"], "2"], ",", 
   SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "}"}]}], "Input",
 CellChangeTimes->{3.5768483159147882`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], 
  SqrtBox["2"]]], "Output",
 CellChangeTimes->{3.576848321217228*^9, 3.5769218501948166`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "2"]}], ",", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", "\[Pi]"], "2"], ",", 
   SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "}"}]], "Output",
 CellChangeTimes->{3.576848321217228*^9, 3.5769218501948166`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], 
  SqrtBox["2"]]], "Output",
 CellChangeTimes->{3.576848321217228*^9, 3.5769218501948166`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "2"]}], ",", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", "\[Pi]"], "2"], ",", 
   SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "}"}]], "Output",
 CellChangeTimes->{3.576848321217228*^9, 3.5769218501948166`*^9}]
}, Open  ]],

Cell["View the osculating circle.", "Text",
 CellChangeTimes->{{3.5448318063201723`*^9, 3.544831813358575*^9}, {
  3.544831849175624*^9, 3.54483186117531*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"radius", "=", 
     RowBox[{"1", "/", 
      RowBox[{"\[Kappa]", "[", "t", "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"center", "=", 
     RowBox[{
      RowBox[{"c", "[", "t", "]"}], "+", 
      RowBox[{"radius", " ", 
       RowBox[{"uN", "[", "t", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"dP", "=", 
     RowBox[{".01", 
      RowBox[{
       RowBox[{"uN", "[", "t", "]"}], "\[Cross]", 
       RowBox[{"uT", "[", "t", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"c", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          SqrtBox["3"], ",", 
          RowBox[{
           SqrtBox["3"], 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", "\[Pi]"}]]}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"PointSize", "[", ".02", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"c", "[", "t", "]"}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "Tiny", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"c", "[", "t", "]"}], ",", 
            RowBox[{
             RowBox[{"c", "[", "t", "]"}], "+", 
             RowBox[{"uT", "[", "t", "]"}]}]}], "}"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"c", "[", "t", "]"}], ",", "center"}], "}"}], "]"}], ",", 
         RowBox[{"Opacity", "[", "0", "]"}], ",", 
         RowBox[{"Cylinder", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"center", "-", "dP"}], ",", 
             RowBox[{"center", "+", "dP"}]}], "}"}], ",", "radius"}], "]"}]}],
         "}"}], "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     SqrtBox["3"], ",", 
     RowBox[{
      SqrtBox["3"], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", "\[Pi]"}]]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544800417027334*^9, 3.5448005297439256`*^9}, {
   3.5448007617555017`*^9, 3.544800783968109*^9}, {3.5448121021297655`*^9, 
   3.544812105494438*^9}, 3.5448246307687545`*^9, {3.544824715576605*^9, 
   3.544824755738902*^9}, {3.5448248363295116`*^9, 3.5448248385946417`*^9}, 
   3.54482486898438*^9, {3.5448249393494043`*^9, 3.5448249474278665`*^9}, 
   3.544825052416871*^9, {3.544825314381855*^9, 3.54482534262547*^9}, {
   3.5448254429612093`*^9, 3.5448254535178127`*^9}, {3.544825566443272*^9, 
   3.5448255948108945`*^9}, {3.544825953683421*^9, 3.5448259688072863`*^9}, {
   3.5448260603875237`*^9, 3.5448260624406414`*^9}, {3.544829563292879*^9, 
   3.5448295690042057`*^9}, {3.5448296082074475`*^9, 
   3.5448296757903132`*^9}, {3.544829754000787*^9, 3.544829839621684*^9}, {
   3.54482989724498*^9, 3.544829918196178*^9}, 3.5448299677040095`*^9, {
   3.5448300122625585`*^9, 3.5448300153447347`*^9}, {3.5448300460724916`*^9, 
   3.5448300826165824`*^9}, {3.5448303204191837`*^9, 3.544830335337037*^9}, {
   3.544830459834158*^9, 3.54483052753903*^9}, {3.5448305933067923`*^9, 
   3.5448305946588697`*^9}, {3.544830663096784*^9, 3.5448306677350492`*^9}, {
   3.544830702782054*^9, 3.5448307262043934`*^9}, {3.5448309457639513`*^9, 
   3.544830975793669*^9}, 3.5448310898781943`*^9, {3.5448312515524416`*^9, 
   3.544831281897177*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 842.5895430634453, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 3^Rational[1, 2], 3^Rational[1, 2] E^(2 Pi)}}, 
    Typeset`size$$ = {333., {266., 274.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`t$638$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 3^Rational[1, 2]}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$638$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`radius = 
        1/$CellContext`\[Kappa][$CellContext`t$$]; $CellContext`center = \
$CellContext`c[$CellContext`t$$] + $CellContext`radius \
$CellContext`uN[$CellContext`t$$]; $CellContext`dP = 0.01 Cross[
           $CellContext`uN[$CellContext`t$$], 
           $CellContext`uT[$CellContext`t$$]]; Show[
         ParametricPlot3D[
          $CellContext`c[$CellContext`t$$], {$CellContext`t$$, 3^
           Rational[1, 2], 3^Rational[1, 2] E^(2 Pi)}], 
         Graphics3D[{Blue, 
           PointSize[0.02], 
           Point[
            $CellContext`c[$CellContext`t$$]], 
           Arrowheads[Tiny], 
           Arrow[{
             $CellContext`c[$CellContext`t$$], \
$CellContext`c[$CellContext`t$$] + $CellContext`uT[$CellContext`t$$]}], 
           Arrow[{
             $CellContext`c[$CellContext`t$$], $CellContext`center}], 
           Opacity[0], 
           
           Cylinder[{$CellContext`center - $CellContext`dP, \
$CellContext`center + $CellContext`dP}, $CellContext`radius]}]]), 
      "Specifications" :> {{$CellContext`t$$, 3^Rational[1, 2], 
         3^Rational[1, 2] E^(2 Pi)}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{390., {337., 344.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.576848325188366*^9, 3.576921850491232*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1008, 730},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.25, 1.25 Inherited],
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 186, 4, 181, "Title"],
Cell[CellGroupData[{
Cell[790, 30, 149, 2, 98, "Section"],
Cell[CellGroupData[{
Cell[964, 36, 1618, 45, 109, "Subsubsection"],
Cell[2585, 83, 688, 19, 63, "Text"],
Cell[CellGroupData[{
Cell[3298, 106, 1999, 57, 161, "Input"],
Cell[5300, 165, 38170, 647, 290, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43507, 817, 1488, 42, 164, "Input"],
Cell[44998, 861, 2220, 47, 669, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47255, 913, 1972, 50, 151, "Input"],
Cell[49230, 965, 2394, 51, 669, "Output"]
}, Open  ]],
Cell[51639, 1019, 387, 6, 38, "Text"],
Cell[52029, 1027, 205, 4, 38, "Text"],
Cell[CellGroupData[{
Cell[52259, 1035, 138, 3, 36, "Input"],
Cell[52400, 1040, 657, 19, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53094, 1064, 172, 4, 36, "Input"],
Cell[53269, 1070, 843, 25, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54149, 1100, 272, 7, 36, "Input"],
Cell[54424, 1109, 191, 5, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54652, 1119, 600, 15, 83, "Input"],
Cell[55255, 1136, 309, 6, 40, "Output"],
Cell[55567, 1144, 408, 10, 43, "Output"],
Cell[55978, 1156, 254, 3, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56269, 1164, 691, 18, 64, "Input"],
Cell[56963, 1184, 303, 5, 40, "Output"],
Cell[57269, 1191, 461, 11, 43, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57779, 1208, 145, 1, 42, "Subsubsection"],
Cell[57927, 1211, 458, 14, 38, "Text"],
Cell[58388, 1227, 669, 16, 63, "Text"],
Cell[59060, 1245, 1149, 38, 51, "Text"],
Cell[CellGroupData[{
Cell[60234, 1287, 1117, 33, 87, "Input"],
Cell[61354, 1322, 435, 7, 36, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61838, 1335, 228, 4, 42, "Subsubsection"],
Cell[62069, 1341, 910, 36, 63, "Text"],
Cell[62982, 1379, 207, 4, 63, "Text"],
Cell[63192, 1385, 713, 24, 38, "Text"],
Cell[63908, 1411, 1120, 40, 45, "Text"],
Cell[65031, 1453, 433, 14, 38, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65501, 1472, 113, 1, 42, "Subsubsection"],
Cell[65617, 1475, 456, 8, 88, "Text"],
Cell[66076, 1485, 1180, 36, 45, "Text"],
Cell[67259, 1523, 188, 2, 38, "Text"],
Cell[CellGroupData[{
Cell[67472, 1529, 1831, 47, 141, "Input"],
Cell[69306, 1578, 1990, 44, 581, "Output"]
}, Open  ]],
Cell[71311, 1625, 239, 5, 38, "Text"],
Cell[CellGroupData[{
Cell[71575, 1634, 2031, 53, 129, "Input"],
Cell[73609, 1689, 1819, 40, 583, "Output"]
}, Open  ]],
Cell[75443, 1732, 503, 15, 63, "Text"],
Cell[75949, 1749, 167, 2, 38, "Text"],
Cell[CellGroupData[{
Cell[76141, 1755, 601, 21, 61, "Input"],
Cell[76745, 1778, 552, 20, 75, "Output"]
}, Open  ]],
Cell[77312, 1801, 342, 7, 36, "Input"],
Cell[CellGroupData[{
Cell[77679, 1812, 123, 2, 36, "Input"],
Cell[77805, 1816, 753, 27, 70, "Output"]
}, Open  ]],
Cell[78573, 1846, 359, 8, 36, "Input"],
Cell[CellGroupData[{
Cell[78957, 1858, 180, 3, 36, "Input"],
Cell[79140, 1863, 918, 30, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80095, 1898, 330, 8, 36, "Input"],
Cell[80428, 1908, 173, 5, 119, "Output"]
}, Open  ]],
Cell[80616, 1916, 356, 9, 36, "Input"],
Cell[CellGroupData[{
Cell[80997, 1929, 174, 3, 36, "Input"],
Cell[81174, 1934, 2554, 86, 261, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83765, 2025, 326, 8, 36, "Input"],
Cell[84094, 2035, 792, 27, 75, "Output"]
}, Open  ]],
Cell[84901, 2065, 342, 11, 40, "Text"],
Cell[CellGroupData[{
Cell[85268, 2080, 972, 32, 170, "Input"],
Cell[86243, 2114, 192, 5, 62, "Output"],
Cell[86438, 2121, 372, 10, 56, "Output"],
Cell[86813, 2133, 192, 5, 62, "Output"],
Cell[87008, 2140, 372, 10, 56, "Output"]
}, Open  ]],
Cell[87395, 2153, 159, 2, 38, "Text"],
Cell[CellGroupData[{
Cell[87579, 2159, 3621, 81, 267, "Input"],
Cell[91203, 2242, 2618, 55, 701, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
